%
% function r = z2r(Z, Z0);
%
% Transforms impedance Z into reflexion coefficient r (with
% reference impedance Z0).
%
% Parameters:  Z   - complex impedance
%              Z0  - (optional) reference impedance; default 50 ohms
%              r   - complex reflexion factor
% In "z2r(z,1)", z is the normalized impedance.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function r = z2r(Z, Z0);

if (nargin < 1) | (nargin > 2)
    error('One or two input parameters are required!');
end
if ischar(Z)
    error('First input parameter has to be numerical!');
end
if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Second input parameter has to be numerical!');
    elseif length(Z0) ~= 1
        error('Second input parameter has to be scalar!');
    end
end

m     = (Z ~= -Z0);     % Leerlufe merken
r( m) = (Z(m) - Z0) ./ (Z(m) + Z0);
r(~m) = inf;            % plus oder minus unendlich ist egal !

m     = (Z == inf);     % ein weiterer Spezialfall
r( m) = 1;
