%
% function r = y2r(Y, Y0);
%
% Transforms admittance Y into reflexion coefficient r (with
% reference admittance Y0).
%
% Parameters:  Y   - complex admittance
%              Y0  - (optional) reference admittance; default 20 mS
%              r   - complex reflexion coefficient
% In "y2r(y,1)", y is the normalized admittance.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function r = y2r(Y, Y0);

if (nargin < 1) | (nargin > 2)
    error('One or two input parameters are required!');
end
if ischar(Y)
    error('First input parameter has to be numerical!');
end
if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Second input parameter has to be numerical!');
    elseif length(Y0) ~= 1
        error('Second input parameter has to be scalar!');
    end
end

m     = (Y ~= -Y0);   % Spezialfall merken
r( m) = (Y0 - Y(m)) ./ (Y0 + Y(m));
r(~m) = inf;          % plus oder minus unendlich ist egal !

m     = (Y == inf);   % ein weiterer Spezialfall
r( m) = -1;
