%
% function rdB = swr2rdB(swr);
%
% Calculates the absolute value of the reflexion coefficient in decibel
% using the standing wave ratio (SWR).
%
% Parameters:   swr  -  (voltage) standing wave ration
%               rdB  -  absolute value of the reflexion coefficient (dB)
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function rdB = swr2rdB(swr);

if nargin ~= 1
    error('One parameter is required!');
end
if ischar(swr)
    error('Input parameter has to be numerical!');
end

if ~isreal(swr)
    error('A complex SWR does not exist!');
end
if any((swr<1) & (swr~=-1))
    error('SWR has to be -1 or 1<=swr<=inf!');
end

m        = (swr ~= -1);      % Ausnahmenfall beachten
n        = (swr ~=  1);      % Ausnahmenfall beachten
rdB(m&n) = 20*log10( (swr(m&n)-1) ./ (swr(m&n)+1) );
rdB(~m)  =  inf;
rdB(~n)  = -inf;
