%
% function Z = r2z(r, Z0);
%
% Transforms reflexion coefficient r (refered to impedance Z0) into
% impedance Z.
%
% Parameters:  r   - complex reflexion coefficient
%              Z0  - (optional) reference impedance; default 50 ohms
%              Z   - complex impedance
% Using "r2z(r,1)" one obtains the normalized impedance.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function Z = r2z(r, Z0);

if (nargin < 1) | (nargin > 2)
    error('One or two input parameters are required!');
end
if ischar(r)
    error('First input parameter has to be numerical!');
end
if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Second input parameter has to be numerical!');
    elseif length(Z0) ~= 1
        error('Second input parameter has to be scalar!');
    end
end

m     = (r ~= 1);     % Leerlufe merken
Z( m) = Z0 * (1 + r(m)) ./ (1 - r(m));
Z(~m) = inf;          % Leerlufe ergeben unendlich

m     = (r == inf);   % ein weiterer Spezialfall
Z( m) = -Z0;
