%
% function Y = r2y(r, Y0);
%
% Transforms reflexion coefficient r (refered to admittance Y0) into
% admittance Y.
%
% Parameters:  r   - complex reflexion coefficient
%              Y0  - (optional) reference admittance; default 20 mS
%              Y   - complex admittance
% Using "r2y(r,1)" one obtains the normalized admittance.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function Y = r2y(r, Y0);

if (nargin < 1) | (nargin > 2)
    error('One or two input parameters are required!');
end
if ischar(r)
    error('First input parameter has to be numerical!');
end
if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Second input parameter has to be numerical!');
    elseif length(Y0) ~= 1
        error('Second input parameter has to be scalar!');
    end
end

m     = (r ~= -1);    % Kurzschlsse merken
Y( m) = Y0 * (1 - r(m)) ./ (1 + r(m));
Y(~m) = inf;          % Kurzschlsse ergeben unendlich

m     = (r == inf);   % ein weiterer Spezialfall
Y( m) = -Y0;
