%
% function SWR = r2swr(r);
%
% Calculates (voltage) standing wave ratio (SWR, VSWR) using
% reflexion coefficient r.
%
% Paramters:  r   -  complex reflexion coefficient
%             SWR -  standing wave ratio
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function SWR = r2swr(r);

if nargin ~= 1
    error('One input parameter is required!');
end
if ischar(r)
    error('Input parameter has to be numerical!');
end

m       = (abs(r) ~= 1);      % Totalreflexion abfangen
SWR( m) = ( 1+abs(r(m)) ) ./ ( 1-abs(r(m)) );
SWR(~m) = inf;

m       = (abs(r) == inf);    % weiterer Spezialfall
SWR( m) = -1;
