%
% function f = mu2(S);
%
% Calculates the '-factor, s stability factor of the source. A
% 2-port network is unconditionally stable, if and only if, the
% '-factor is above one.
%
% Parameters:   S  -  S-parameters of a 2-port network
%               f  -  '-factor
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function f = mu2(S);

if nargin ~= 1
    error('One input parameter is required!');
end
if ischar(S)
    error('Input parameter has to be numerical!');
end
[m, n] = size(S);
if n ~= 4
    error('Stability factor is only defined for 2-port networks!');
end

m     = (S(:,2).*S(:,3) ~= 0);   % unilateral 2-port network
f( m) = ( 1-abs(S(m,4)).^2 ) ./ (abs(S(m,1)-conj(S(m,4)).*(S(m,1).*S(m,4) - S(m,2).*S(m,3))) + abs(S(m,3).*S(m,2)));

n     = ((~m) & (abs(S(:,4)) == 1));
f( n) = NaN;    % converge against +1 and -1
n     = ((~m) & (abs(S(:,4)) ~= 1));
f( n) = sign(1-S(n,4).^2) ./ abs(S(n,1));
