% This is a small example showing the usage of the Microwave Toolbox.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%



[f, S, g, N] = LoadSnP('BFR520J.S2P');    % load S-parameter and noise parameter

figure(1)           % open new figure
subplot(2,2,1)      % four diagrams within one figure
smith(S(:,1),'r')   % plot S11 red
title('S11 of BFR520J')

subplot(2,2,2)
polar(angle(S(:,2)), abs(S(:,2)),'g')   % plot S12 green
title('S12 of BFR520J')

subplot(2,2,3)
polar(angle(S(:,3)), abs(S(:,3)),'b')   % plot S21 blue
title('S21 of BFR520J')

subplot(2,2,4)
smith(S(:,4),'c')   % plot S22 cyan
title('S22 of BFR520J')

F      = [1.8 2.5 4];       % circles for noise figures 1.8, 2.5 and 4
index  = find(g == 1e9);    % seek noise figures at 1GHz
NCircle = NoiseCircle(N(index,:),F);    % calculates noise circles at 1GHz

figure(2)           % open second figure
subplot(2,2,1)      % four diagrams within one figure
smith(NCircle)      % draw three noise circles
title('noise circles at 1GHz');

subplot(2,2,2)
plot(f/1e9, mu(S))      % plot -factor
title('\mu_1-factor of BFR520J');
xlabel('frequency (GHz)')
ylabel('\mu_1')

subplot(2,2,3)
plot(f/1e9, mu2(S))      % plot '-factor
title('\mu_2-factor of BFR520J');
xlabel('frequency (GHz)')
ylabel('\mu_2')

subplot(2,2,4)
plot(f/1e9, Kfactor(S))      % plot K-factor
title('K-factor of BFR520J');
xlabel('frequency (GHz)')
ylabel('K-factor')
