%
% function SdB = dB(S);
%
% Calculates absolute values in decibel from S-parameters in S.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function SdB = dB(S);

if nargin~=1
   error('Exactly one input parameter is required!');
end
if ischar(S)
   error('Input parameter has to be numerical!');
end

m       = (S ~= 0);     % catch special cases
SdB( m) = 20*log10(abs(S(m)));
SdB(~m) = -inf;
