%
% Microwave Toolbox
% Version 2.6   (June 2003)
% Author: Michael Margraf, margraf@mwt.ee.tu-berlin.de
% Co-Autor: Johannes Horn, horn@mwt.ee.tu-berlin.de
% MATLAB version: 6.0.0.88 Release 12
% Status: Freeware
%
% I always look forward to feedback (suggestions for improvements, bugs,
% success etc.). The usage of all programmes, as well as copying and
% distribution is absolutely free. Changes have to be clearly labeled.
% The programme informations (name of the author, version etc.) must not
% be deleted.
% The author is not responsible for any kind of damage caused by the
% programme.
%
% The "Microwave Toolbox" contains functions often needed by microwave
% engineers. All routines are solitary executable, i.e. none of them
% runs another routine of the toolbox.
% All routines needs (if nothing else is stated) complex S-parameters
% owning a reference impedance of 50 ohms.
% A matrix contains one S-parameter within every column and one frequency
% within every row.
% Noise parameters are also collected in a matrix. They have to contain
% the following columns in every row: minimum noise figure, optimized
% source reflexion coefficient normalized to 50 ohms, normalized effective
% noise impedance (also normalized to 50 ohms).
% Every function has got a short description that can be display on the
% MATLAB console bei entering "help <function name>". (example: help smith)
% The function parameters are also obtained this way.
%
% Distributed files:
%  example.m               a short programme example
%  BFR520J.S2P             S-parameter file needed by "example.m"
%
% Functions of the Microwave Toolbox:
%  smith(S [,type])        draws curves within a smith chart
%  ysmith(S [,type])       smith chart with admittance curves
%  r = z2r(Z [,Z0])        transforms impedance to reflexion coefficient
%  r = y2r(Y [,Y0])        transforms admittance to reflexion coefficient
%  Z = r2z(r [,Z0])        transforms reflexion coefficient to impedance
%  Y = r2y(r [,Y0])        transforms reflexion coefficient to admittance
%  SdB = dB(S)             calculates S-parameter absolute values in dB
%  [f,S,fN,N]=LoadSnP(name)    imports data from a Touchstone file
%  SaveSnP(name,f,S [,fN,N])   exports data to a Touchstone file
%  SaveCITI(file,u,a[,names])  exports data to a CITI file
%  [K,R]=StabCircleG(S[,n])    stability circles of the generator
%  [K,R]=StabCircleL(S[,n])    stability circles of the load
%  [K,d] = Kfactor(S)      stability factor by Rollet (K-factor)
%  f = mu(S)               -factor (stability factor for the load)
%  f = mu2(S)              '-factor (stability factor for the source)
%  SWR = r2swr(r)          transforms reflexion coefficient to SWR
%  rdB = swr2rdB(swr)      transforms SWR to reflexion coefficient in dB
%  S_Z1=Snorm(S_Z0,Z0,Z1)  changes reference impedance of S-parameters
%  S = chain(Sa, Sb)       calculates chain connection of 2-port networks
%  K=NoiseCircles(N,F[,n]) calculates circles with constant noise figure
%  Z = S2Z(S [,Z0])        transforms S-parameter to Z-parameter
%  S = Z2S(Z [,Z0])        transforms Z-parameter to S-parameter
%  Y = S2Y(S [,Y0])        transforms S-parameter to Y-parameter
%  S = Y2S(Y [,Y0])        transforms Y-parameter to S-parameter
%  A = S2A(S [,Z0])        transforms S-parameter to chain parameter
%  S = A2S(A [,Z0])        transforms chain parameter to S-parameter
%  H = S2H(S [,Z0])        transforms S-parameter to hybrid parameter
%  S = H2S(H [,Z0])        transforms hybrid parameter to S-parameter
%  G = MSGvalue(S)         calculates maximum stable gain (MSG)
%  G = MAGvalue(S)         calculates maximum available gain (MAG)
%