%
% function G = MSGvalue(S);
%
% Calculates the maximum stable gain (MSG) of a 2-port network in
% forward direction, i.e. the upper limit of the maximum power
% amplification of a linear, conditionally stable circuit (when
% stability factor K -> 1, stabilized with ohmic resistance at
% input and output).
%
% Parameters:   S   -  S-parameters of a 2-port network
%               MSG -  MSG of 2-port network (linear, not in decibel)
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, developed with MATLAB 6.0.0.88 Release 12
%

function G = MSGvalue(S);

if nargin ~= 1
    error('One input parameter is required!');
end
if ischar(S)
    error('Input parameter has to be numerical!');
end
[m, n] = size(S);
if n ~= 4
    error('MSG is only defined for 2-port networks!');
end

m     = (S(:,2) ~= 0);     % unilateral cases
G( m) = abs(S(m,3)) ./ abs(S(m,2));
G(~m) = abs(S(~m,3)).^2 ./ (1-abs(S(~m,1)).^2) ./ (1-abs(S(~m,4)).^2);
