%
% function r = z2r(Z, Z0);
%
% Wandelt Impedanz Z in Reflexionsfaktor r (bezglich
% System-Impedanz Z0) um.
%
% Parameter:   Z   - komplexe Impedanz
%              Z0  - (optional) Systemimpedanz; default 50 Ohm
%              r   - komplexer Reflexionsfaktor
% In "z2r(z,1)" ist z also die normierte Impedanz.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function r = z2r(Z, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(Z)
    error('Parameter mssen numerisch sein!');
end
if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Parameter mssen numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

m     = (Z ~= -Z0);     % Leerlufe merken
r( m) = (Z(m) - Z0) ./ (Z(m) + Z0);
r(~m) = inf;            % plus oder minus unendlich ist egal !

m     = (Z == inf);     % ein weiterer Spezialfall
r( m) = 1;
