%
% function r = y2r(Y, Y0);
%
% Wandelt Admittanz Y in Reflexionsfaktor r (bezglich
% System-Admittanz Y0) um.
%
% Parameter:   Y   - komplexe Admittanz
%              Y0  - (optional) Systemadmittanz; default 20 mS
%              r   - komplexer Reflexionsfaktor
% In "y2r(y,1)" ist y also die normierte Admittanz.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function r = y2r(Y, Y0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(Y)
    error('Parameter mssen numerisch sein!');
end
if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Parameter mssen numerisch sein!');
    elseif length(Y0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

m     = (Y ~= -Y0);   % Spezialfall merken
r( m) = (Y0 - Y(m)) ./ (Y0 + Y(m));
r(~m) = inf;          % plus oder minus unendlich ist egal !

m     = (Y == inf);   % ein weiterer Spezialfall
r( m) = -1;
