%
% function rdB = swr2rdB(swr);
%
% Berechnet aus dem Stehwellenverhltnis den Betrag des
% Reflexionsfaktor in Dezibel.
%
% Parameter:    swr  -  Stehwellenverhltnis
%               rdB  -  Betrag des Reflexionsfaktors in Dezibel
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function rdB = swr2rdB(swr);

if nargin ~= 1
    error('Es mu genau ein Parameter bergeben werden!');
end
if ischar(swr)
    error('Eingabe-Parameter mu numerisch sein!');
end

if ~isreal(swr)
    error('Komplexe Stehwellenverhltnisse gibt es nicht!');
end
if any((swr<1) & (swr~=-1))
    error('Stehwellenverhltnis mu -1 oder 1<=swr<=inf sein!');
end

m        = (swr ~= -1);      % Ausnahmenfall beachten
n        = (swr ~=  1);      % Ausnahmenfall beachten
rdB(m&n) = 20*log10( (swr(m&n)-1) ./ (swr(m&n)+1) );
rdB(~m)  =  inf;
rdB(~n)  = -inf;
