%
% function Z = r2z(r, Z0);
%
% Wandelt Reflexionsfaktor r (bezglich System-Impedanz Z0) in
% Impedanz Z um.
%
% Parameter:   r   - komplexer Reflexionsfaktor
%              Z0  - (optional) Systemimpedanz; default 50 Ohm
%              Z   - komplexe Impedanz
% Mit "r2z(r,1)" erhlt man also die normierte Impedanz.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function Z = r2z(r, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(r)
    error('Parameter mssen numerisch sein!');
end
if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Parameter mssen numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

m     = (r ~= 1);     % Leerlufe merken
Z( m) = Z0 * (1 + r(m)) ./ (1 - r(m));
Z(~m) = inf;          % Leerlufe ergeben unendlich

m     = (r == inf);   % ein weiterer Spezialfall
Z( m) = -Z0;
