%
% function Y = r2y(r, Y0);
%
% Wandelt Reflexionsfaktor r (bezglich System-Admittanz Y0) in
% Admittanz Y um.
%
% Parameter:   r   - komplexer Reflexionsfaktor
%              Y0  - (optional) Systemadmittanz; default 20 mS
%              Y   - komplexe Admittanz
% Mit "r2y(r,1)" erhlt man also die normierte Admittanz.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function Y = r2y(r, Y0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(r)
    error('Parameter mssen numerisch sein!');
end
if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Parameter mssen numerisch sein!');
    elseif length(Y0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

m     = (r ~= -1);    % Kurzschlsse merken
Y( m) = Y0 * (1 - r(m)) ./ (1 + r(m));
Y(~m) = inf;          % Kurzschlsse ergeben unendlich

m     = (r == inf);   % ein weiterer Spezialfall
Y( m) = -Y0;
