%
% function SWR = r2swr(r);
%
% Berechnet die Welligkeit (Stehwellen-Verhltnis, SWR, VSWR) aus
% dem Reflexionsfaktor r.
%
% Paramter:   r   -  komplexer Reflexionsfaktor
%             SWR -  Wellingkeit
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function SWR = r2swr(r);

if nargin ~= 1
    error('Es mu genau ein Parameter bergeben werden!');
end
if ischar(r)
    error('Eingabe-Parameter mu numerisch sein!');
end

m       = (abs(r) ~= 1);      % Totalreflexion abfangen
SWR( m) = ( 1+abs(r(m)) ) ./ ( 1-abs(r(m)) );
SWR(~m) = inf;

m       = (abs(r) == inf);    % weiterer Spezialfall
SWR( m) = -1;
