%
% function f = mu(S);
%
% Berechnet den -Faktor, ein Stabilittsfaktor fr die Last-
% Impedanzebene. Ein 2-Tor ist absolut stabil, genau dann, falls
% der -Faktor grer als eins ist.
%
% Parameter:    S  -  2-Tor-S-Parameter
%               f  -  -Faktor
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function f = mu(S);

if nargin ~= 1
    error('Es mu genau ein Parameter bergeben werden!');
end
if ischar(S)
    error('Eingabe-Parameter mu numerisch sein!');
end
[m, n] = size(S);
if n ~= 4
    error('Stabilittsfaktor ist nur fr 2-Tore definiert!');
end

m     = (S(:,2).*S(:,3) ~= 0);   % unilaterales 2-Tor
f( m) = ( 1-abs(S(m,1)).^2 ) ./ (abs(S(m,4)-conj(S(m,1)).*(S(m,1).*S(m,4) - S(m,2).*S(m,3))) + abs(S(m,3).*S(m,2)));

n     = ((~m) & (abs(S(:,1)) == 1));
f( n) = NaN;    % konvergiert gegen +1 und -1
n     = ((~m) & (abs(S(:,1)) ~= 1));
f( n) = sign(1-S(n,1).^2) ./ abs(S(n,4));
