%
% function SdB = dB(S);
%
% Erzeugt Dezibel-Betrge aus den S-Parameter in S.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function SdB = dB(S);

if nargin~=1
   error('Es mu genau ein Eingabeparameter bergeben werden!');
end
if ischar(S)
   error('Eingabeparameter mu numerisch sein!');
end

m       = (S ~= 0);     % Spezialfall abfangen
SdB( m) = 20*log10(abs(S(m)));
SdB(~m) = -inf;
