%
% Microwave Toolbox
% Version 2.6   (21. Juni 2003)
% Autor: Michael Margraf, margraf@mwt.ee.tu-berlin.de
% Co-Autor: Johannes Horn, horn@mwt.ee.tu-berlin.de
% MATLAB-Version: 6.0.0.88 Release 12
% Status: freie, kostenlose Programme
%
% ber Rckmeldungen (Verbesserungsvorschlge, Fehler, Erfolge
% etc.) freue ich mich jederzeit. Die Benutzung aller Programme
% sowie das Kopieren und Weitergeben ist absolut frei und
% erwnscht. Bei nderungen mssen diese deutlich gekennzeichnet
% werden. Die Programm-Informationen (Name des Autors, Versions-
% Nummer etc.) drfen nicht entfernt werden.
% Fr Schden u.., die durch die Programme entstehen, ist
% der Autor nicht verantwortlich.
%
% Die "Mikrowellen Toolbox" enthlt Funktionen, die oft von
% Mikrowellen-Technikern bentigt werden. Alle Routinen sind
% einzeln lauffhig, d.h. keine ruft eine andere aus dieser
% Toolbox auf.
% Alle Routinen arbeiten (wenn nicht anders vermerkt) mit
% komplexen S-Parametern mit Referenz-Impedanz 50 Ohm.
% Matrizen enthalten in jeder Spalte einen S-Parameter und
% in jeder Zeile eine Frequenz.
% Die Rauschparameter werden ebenfalls in einer Matrix zu-
% sammengefat. Sie mssen in jeder Zeile folgende Spalten
% aufweisen: min. Rauschzahl in dB, optimaler Quellenreflexions-
% faktor normiert auf 50 Ohm, normalisierter effektiver
% Rauschwiderstand (ebenfalls auf 50 Ohm normiert).
% Zu jeder Funktion kann ber die MATLAB-Console durch Eingabe
% von "help <Funktionsname>" eine kurze Erklrung aufgerufen.
% (Beispiel: help smith) Hier werden auch alle Parameter
% beschrieben.
%
% Mitgelieferte Dateien:
%  Beispiel.m              Ein kleines Beispiel-Programm.
%  BFR520J.S2P             Datei wird von "Beispiel.m" bentigt.
%
% Funktionen der Mikrowellen-Toolbox:
%  smith(S [,Type])        Zeichnet Kurven in ein Smith-Diagramm.
%  ysmith(S [,Type])       Smith-Diagramm mit Admittanz-Kurven
%  r = z2r(Z [,Z0])        Rechnet Impedanz in Reflexionsfaktor um.
%  r = y2r(Y [,Y0])        Rechnet Admittanz in Reflexionsfaktor um.
%  Z = r2z(r [,Z0])        Rechnet Reflexionsfaktor in Impedanz um.
%  Y = r2y(r [,Y0])        Rechnet Reflexionsfaktor in Admittanz um.
%  SdB = dB(S)             Ergibt die S-Parameter-Betrge in dB.
%  [f,S,fN,N]=LadeSnP(Name)        Liet Daten aus einer Touchstone-Datei.
%  SpeicherSnP(Name,f,S [,fN,N])   Schreibt Daten in eine Touchstone-Datei.
%  SpeicherCITI(Datei,u,a[,Namen]) Schreibt Daten in eine CITI-Datei.
%  [K,d] = Kfaktor(S)              Stabilittsfaktor nach Rollet (K-Faktor)
%  f = mu(S)               -Faktor (Stabilittsfaktor der Last-Ebene)
%  f = mu2(S)              '-Faktor (Stabilittsfaktor der Quellen-Ebene)
%  SWR = r2swr(r)          Rechnet Reflexionsfaktor in Welligkeit um.
%  rdB = swr2rdB(swr)      Welligkeit in Reflexionsfaktor (dB) umrechnen
%  S_Z1=Snorm(S_Z0,Z0,Z1)  Referenzimpedanz von S-Parametern ndern
%  S = Kette(Sa, Sb)       Kettenschaltung von 2-Toren berechnen
%  K=RauschKreise(N,F[,n]) Kreise konstanter Rauschzahl berechnen
%  [K,R]=StabKreisG(S[,n]) Stabilittskreise des Generators berechnen
%  [K,R]=StabKreisL(S[,n]) Stabilittskreise der Last berechnen
%  Z = S2Z(S [,Z0])        Rechnet S-Parameter in Z-Parameter um.
%  S = Z2S(Z [,Z0])        Rechnet Z-Parameter in S-Parameter um.
%  Y = S2Y(S [,Y0])        Rechnet S-Parameter in Y-Parameter um.
%  S = Y2S(Y [,Y0])        Rechnet Y-Parameter in S-Parameter um.
%  A = S2A(S [,Z0])        Rechnet S-Parameter in Ketten-Parameter um.
%  S = A2S(A [,Z0])        Rechnet Ketten-Parameter in S-Parameter um.
%  H = S2H(S [,Z0])        Rechnet S-Parameter in Hybrid-Parameter um.
%  S = H2S(H [,Z0])        Rechnet Hybrid-Parameter in S-Parameter um.
%  G = MSGwert(S)          Berechnet maximalen stabilen Gewinn (MSG)
%  G = MAGwert(S)          Berechnet maximalen verfgbaren Gewinn (MAG)
%