%
% function S = Z2S(Z, Z0);
%
% Wandelt Widerstands-Parameter (Z-Parameter) eines 2-Tores in
% S-Parameter um.
%
% Parameter:   Z  - Z-Parameter des 2-Tores
%              Z0 - (optional) Bezugsimpedanz der S-Parameter;
%                   default 50 Ohm
%              S  - S-Parameter des 2-Tores normiert auf Z0
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function S = Z2S(Z, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(Z)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(Z);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

Z      = Z/Z0;  % Z-Parameter normieren
Nenner = (1+Z(:,1)).*(1+Z(:,4)) - Z(:,2).*Z(:,3);

S(:,1) = ((Z(:,1)-1).*(Z(:,4)+1) - Z(:,2).*Z(:,3)) ./ Nenner;
S(:,2) = 2*Z(:,2) ./ Nenner;
S(:,3) = 2*Z(:,3) ./ Nenner;
S(:,4) = ((Z(:,1)+1).*(Z(:,4)-1) - Z(:,2).*Z(:,3)) ./ Nenner;
