%
% function S = Y2S(Y, Y0);
%
% Wandelt Leitwerts-Parameter (Y-Parameter) eines 2-Tores in
% S-Parameter um.
%
% Parameter:   Y  - Y-Parameter des 2-Tores
%              Y0 - (optional) Bezugsadmittanz der S-Parameter;
%                   default 20 mS
%              S  - S-Parameter des 2-Tores normiert auf Y0
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function S = Y2S(Y, Y0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(Y)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(Y);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Y0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

Y      = Y/Y0;  % Y-Parameter normieren
Nenner = (1+Y(:,1)).*(1+Y(:,4)) - Y(:,2).*Y(:,3);

S(:,1) = ((1-Y(:,1)).*(1+Y(:,4)) + Y(:,2).*Y(:,3)) ./ Nenner;
S(:,2) = -2*Y(:,2) ./ Nenner;
S(:,3) = -2*Y(:,3) ./ Nenner;
S(:,4) = ((1+Y(:,1)).*(1-Y(:,4)) + Y(:,2).*Y(:,3)) ./ Nenner;
