%
% function Y = S2Y(S, Y0);
%
% Wandelt S-Parameter eines 2-Tores in Leitwerts-Parameter
% (Y-Parameter) um.
%
% Parameter:   S  - S-Parameter des 2-Tores normiert auf Y0
%              Y0 - (optional) Bezugsadmittanz der S-Parameter;
%                   default 20 mS
%              Y  - Y-Parameter des 2-Tores
%              
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function Y = S2Y(S, Y0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(S)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(S);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Y0 = 2e-2;	% Default-Systemadmittanz ist 20 mS
else
    if ischar(Y0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Y0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

Nenner = (1+S(:,1)).*(1+S(:,4)) - S(:,2).*S(:,3);

Y(:,1) = ((1-S(:,1)).*(1+S(:,4)) + S(:,2).*S(:,3)) ./ Nenner;
Y(:,2) = -2*S(:,2) ./ Nenner;
Y(:,3) = -2*S(:,3) ./ Nenner;
Y(:,4) = ((1+S(:,1)).*(1-S(:,4)) + S(:,2).*S(:,3)) ./ Nenner;

Y = Y*Y0;  % Y-Parameter de-normieren
