%
% function H = S2H(S, Z0);
%
% Wandelt S-Parameter eines 2-Tores in Hybrid-Parameter
% (H-Parameter) um.
%
% Parameter:   S  - S-Parameter des 2-Tores normiert auf Z0
%              Z0 - (optional) Bezugsimpedanz der S-Parameter;
%                   default 50 Ohm
%              H  - Hybrid-Parameter des 2-Tores
%              
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function H = S2H(S, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(S)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(S);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

Nenner = (1-S(:,1)).*(1+S(:,4)) + S(:,2).*S(:,3);

H(:,1) = Z0 * ((1+S(:,1)).*(1+S(:,4)) - S(:,2).*S(:,3)) ./ Nenner;
H(:,2) =  2*S(:,2) ./ Nenner;
H(:,3) = -2*S(:,3) ./ Nenner;
H(:,4) = ((1-S(:,1)).*(1-S(:,4)) - S(:,2).*S(:,3)) ./ Nenner / Z0;
