%
% function A = S2A(S, Z0);
%
% Wandelt S-Parameter eines 2-Tores in Ketten-Parameter
% (A-Parameter) um.
%
% Parameter:   S  - S-Parameter des 2-Tores normiert auf Z0
%              Z0 - (optional) Bezugsimpedanz der S-Parameter;
%                   default 50 Ohm
%              A  - Ketten-Parameter des 2-Tores
%              
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function A = S2A(S, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(S)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(S);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

A(:,1) = ((1+S(:,1)).*(1-S(:,4)) + S(:,2).*S(:,3)) ./ S(:,3) / 2;
A(:,2) = Z0 * ((1+S(:,1)).*(1+S(:,4)) - S(:,2).*S(:,3)) ./ S(:,3) / 2;
A(:,3) = ((1-S(:,1)).*(1-S(:,4)) - S(:,2).*S(:,3)) ./ S(:,3) / 2 / Z0;
A(:,4) = ((1-S(:,1)).*(1+S(:,4)) + S(:,2).*S(:,3)) ./ S(:,3) / 2;
