%
% function G = MSGwert(S);
%
% Berechnet die maximale stabile Leistungsverstrkung (MSG) eines
% 2-Tores in Vorwrtsrichtung. D.h. zurckgegeben wird die obere
% Schranke fr die maximale Verstrkung einer linearen, bedingt
% stabilen Schaltung (also im Grenzfall: Stabilittsfaktor K -> 1,
% stabilisiert mit ohmschen Widerstnden an Ein- und Ausgang).
%
% Parameter:    S   -  2-Tor-S-Parameter
%               MSG -  MSG des 2-Tores (linear, nicht in Dezibel)
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function G = MSGwert(S);

if nargin ~= 1
    error('Es mu genau ein Parameter bergeben werden!');
end
if ischar(S)
    error('Eingabe-Parameter mu numerisch sein!');
end
[m, n] = size(S);
if n ~= 4
    error('Maximaler stabiler Gewinn ist nur fr 2-Tore definiert!');
end

m     = (S(:,2) ~= 0);     % unilaterale Flle merken
G( m) = abs(S(m,3)) ./ abs(S(m,2));
G(~m) = abs(S(~m,3)).^2 ./ (1-abs(S(~m,1)).^2) ./ (1-abs(S(~m,4)).^2);
