%
% function [K, d] = Kfaktor(S);
%
% Berechnet den K-Faktor (Stabilittsfaktor nach Rollet) und den Betrag
% der S-Parameter-Determinante (Hilfsbedingung). Ein 2-Tor ist absolut
% stabil, genau dann, falls der K-Faktor grer als eins und die
% Hilfsbedingung kleiner als eins ist.
%
% Parameter:    S  -  2-Tor-S-Parameter
%               K  -  K-Faktor
%               d  -  Hilfsbedingung
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function [K, d] = Kfaktor(S);

if nargin ~= 1
    error('Es mu genau ein Parameter bergeben werden!');
end
if ischar(S)
    error('Eingabe-Parameter mu numerisch sein!');
end
[m, n] = size(S);
if n ~= 4
    error('Stabilittsfaktor ist nur fr 2-Tore definiert!');
end

m     = (S(:,2).*S(:,3) ~= 0);      % unilaterale 2-Tore getrennt behandeln
d     = abs(S(:,1).*S(:,4) - S(:,2).*S(:,3));   % Betrag der Determinante
h     = 1 - abs(S(:,1)).^2 - abs(S(:,4)).^2 + d.^2;
K( m) = h(m,1) ./ (2*abs(S(m,2).*S(m,3)));    % K-Faktor

n     = ((~m) & (h == 0));  % Sonderbedingungen
K( n) = -1;
n     = ((~m) & (h ~= 0));
K( n) = sign(h(n)) * inf;
