%
% function S = Kette(Sa, Sb);
%
% Berechnet die Ketten-Schaltung von zwei 2-Toren, d.h. das
% Hintereinander-Schalten.
%
% Parameter:   Sa  -  S-Parameter des ersten 2-Tores
%              Sb  -  S-Parameter des zweiten 2-Tores
%              S   -  S-Parameter der Kettenschaltung
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function S = Kette(Sa, Sb);

if nargin ~= 2
    error('Es mssen genau zwei Parameter bergeben werden!');
end
if ischar(Sa) | ischar(Sb)
    error('Eingabe-Parameter mssen numerisch sein!');
end
[m1, n1] = size(Sa);
[m2, n2] = size(Sb);
if (n1~=4) | (n2~=4)
    error('Es mssen 2-Tor-S-Parameter bergeben werden!');
end

n      = 1 - Sb(:,1).*Sa(:,4);
m      = (n ~= 0);    % Sonderflle merken
S(m,1) = Sa(m,1) + Sa(m,2).*Sa(m,3).*Sb(m,1)./n(m,1);  % S11
S(m,2) = Sa(m,2).*Sb(m,2)./n(m,1);                     % S12
S(m,3) = Sa(m,3).*Sb(m,3)./n(m,1);                     % S21
S(m,4) = Sb(m,4) + Sb(m,2).*Sb(m,3).*Sa(m,4)./n(m,1);  % S22

S(~m,1) = inf;  % S11
S(~m,2) = inf;  % S12
S(~m,3) = inf;  % S21
S(~m,4) = inf;  % S22
