% Dies ist ein kleines Beispiel-Programm, da die Arbeitsweise der Mikrowellen-
% Toolbox verdeutlichen soll.
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%



[f, S, g, N] = LadeSnP('BFR520J.S2P');    % S-Parameter und Rauschparameter einlesen

figure(1)           % neues Zeichenfenster ffnen
subplot(2,2,1)      % vier Diagramme in ein Fenster
smith(S(:,1),'r')   % S11 in rot zeichnen
title('S11 von BFR520J')

subplot(2,2,2)
polar(angle(S(:,2)), abs(S(:,2)),'g')   % S12 in grn zeichnen
title('S12 von BFR520J')

subplot(2,2,3)
polar(angle(S(:,3)), abs(S(:,3)),'b')   % S21 in blau zeichnen
title('S21 von BFR520J')

subplot(2,2,4)
smith(S(:,4),'c')   % S22 in cyan zeichnen
title('S22 von BFR520J')

F      = [1.8 2.5 4];       % Kreise fr Rauschzahlen 1,8dB, 2,5dB und 4dB
index  = find(g == 1e9);    % Rauschparameter fr 1GHz suchen
Kreise = RauschKreise(N(index,:),F);    % Rauschkreise fr 1GHz berechnen

figure(2)           % neues Zeichenfenster ffnen
subplot(2,2,1)      % vier Diagramme in ein Fenster
smith(Kreise)       % drei Rauschkreise zeichnen
title('Rauschkreise fr 1GHz');

subplot(2,2,2)
plot(f/1e9, mu(S))      % -Faktor zeichnen
title('\mu_1-Faktor von BFR520J');
xlabel('Frequenz in GHz')
ylabel('\mu_1')

subplot(2,2,3)
plot(f/1e9, mu2(S))      % '-Faktor zeichnen
title('\mu_2-Faktor von BFR520J');
xlabel('Frequenz in GHz')
ylabel('\mu_2')

subplot(2,2,4)
plot(f/1e9, Kfaktor(S))      % K-Faktor zeichnen
title('K-Faktor von BFR520J');
xlabel('Frequenz in GHz')
ylabel('K-Faktor')
