%
% function S = A2S(A, Z0);
%
% Wandelt Ketten-Parameter (A-Parameter) eines 2-Tores in
% S-Parameter um.
%
% Parameter:   A  - Ketten-Parameter des 2-Tores
%              Z0 - (optional) Bezugsimpedanz der S-Parameter;
%                   default 50 Ohm
%              S  - S-Parameter des 2-Tores normiert auf Z0
%
% Microwave Toolbox 2.6, M. Margraf, margraf@mwt.ee.tu-berlin.de
% Freeware, entwickelt mit MATLAB 6.0.0.88 Release 12
%

function S = A2S(A, Z0);

if (nargin < 1) | (nargin > 2)
    error('Es mssen ein oder zwei Parameter bergeben werde!');
end
if ischar(A)
    error('Erster Parameter mu numerisch sein!');
end
[m,n] = size(A);
if n~=4
    error('Spalten-Anzahl des ersten Parameters mu vier sein!');
end

if nargin == 1
    Z0 = 50;	% Default-Systemimpedanz ist 50 Ohm
else
    if ischar(Z0)
        error('Zweiter Parameter mu numerisch sein!');
    elseif length(Z0) ~= 1
        error('Zweiter Parameter mu skalar sein!');
    end
end

Nenner = A(:,1) + A(:,4) + A(:,2)/Z0 + A(:,3)*Z0;

S(:,1) = (A(:,1) - A(:,4) + A(:,2)/Z0 - A(:,3)*Z0) ./ Nenner;
S(:,2) = 2*(A(:,1).*A(:,4) - A(:,2).*A(:,3)) ./ Nenner;
S(:,3) = 2 ./ Nenner;
S(:,4) = (A(:,4) - A(:,1) + A(:,2)/Z0 - A(:,3)*Z0) ./ Nenner;
